﻿//////////////////////////////////////////////
// ShaderPassCustomSlot.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ShaderPassCustomSlot
	{
		public :
	
			// Constructor, destructor
			ShaderPassCustomSlot (System* system) noexcept ;
			virtual ~ShaderPassCustomSlot () ;

			// Getters
			nkMemory::StringView getTypeName () const ;

			// Les fonctions à refaire pour les sous classes
			virtual unsigned int getDataByteSize () = 0 ;
			virtual void fillDataBuffer (void* buffer) = 0 ;
			
		protected :
		
			// Attributs
			// Parent system
			System* _system ;
			// Identifier
			nkMemory::String _typeName ;
	} ;
}